/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.architectury.platform.Mod;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;

public class FTBLibraryCommands {
    public static final Map<UUID, CompoundNBT> EDITING_NBT = new HashMap<UUID, CompoundNBT>();

    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType type) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftblibrary").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a((String)"gamemode").executes(context -> {
            if (!((CommandSource)context.getSource()).func_197035_h().func_184812_l_()) {
                ((CommandSource)context.getSource()).func_197035_h().func_71033_a(GameType.CREATIVE);
            } else {
                ((CommandSource)context.getSource()).func_197035_h().func_71033_a(GameType.SURVIVAL);
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"rain").executes(context -> {
            ((CommandSource)context.getSource()).func_197023_e().func_241113_a_(1000000, 0, !((CommandSource)context.getSource()).func_197023_e().func_72896_J(), false);
            return 1;
        }))).then(Commands.func_197057_a((String)"day").executes(context -> {
            long addDay = (24000L - ((CommandSource)context.getSource()).func_197023_e().func_72820_D() % 24000L + 6000L) % 24000L;
            if (addDay != 0L) {
                for (ServerWorld world : ((CommandSource)context.getSource()).func_197028_i().func_212370_w()) {
                    world.func_241114_a_(world.func_72820_D() + addDay);
                }
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"night").executes(context -> {
            long addDay = (24000L - ((CommandSource)context.getSource()).func_197023_e().func_72820_D() % 24000L + 18000L) % 24000L;
            if (addDay != 0L) {
                for (ServerWorld world : ((CommandSource)context.getSource()).func_197028_i().func_212370_w()) {
                    world.func_241114_a_(world.func_72820_D() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"nbtedit").then(Commands.func_197057_a((String)"block").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSource>)context, (info, tag) -> {
            ITextComponent title;
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos");
            TileEntity blockEntity = ((CommandSource)context.getSource()).func_197023_e().func_175625_s(pos);
            if (blockEntity == null) {
                return;
            }
            info.func_74778_a("type", "block");
            info.func_74768_a("x", pos.func_177958_n());
            info.func_74768_a("y", pos.func_177956_o());
            info.func_74768_a("z", pos.func_177952_p());
            blockEntity.func_189515_b(tag);
            tag.func_82580_o("x");
            tag.func_82580_o("y");
            tag.func_82580_o("z");
            info.func_74778_a("id", tag.func_74779_i("id"));
            tag.func_82580_o("id");
            ListNBT list = new ListNBT();
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Class"), (ITextComponent)new StringTextComponent(blockEntity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)blockEntity.func_200662_C(), (RegistryKey)Registry.field_239667_E_);
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("ID"), (ITextComponent)new StringTextComponent(key == null ? "null" : key.toString()));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Block"), (ITextComponent)new StringTextComponent(String.valueOf(Registries.getId((Object)blockEntity.func_195044_w().func_177230_c(), (RegistryKey)Registry.field_239711_l_))));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Block Class"), (ITextComponent)new StringTextComponent(blockEntity.func_195044_w().func_177230_c().getClass().getName()));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Position"), (ITextComponent)new StringTextComponent("[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]"));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Mod"), (ITextComponent)new StringTextComponent(key == null ? "null" : Platform.getOptionalMod((String)key.func_110624_b()).map(Mod::getName).orElse("Unknown")));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Ticking"), (ITextComponent)new StringTextComponent(blockEntity instanceof ITickableTileEntity ? "true" : "false"));
            info.func_218657_a("text", (INBT)list);
            ITextComponent iTextComponent = title = blockEntity instanceof INameable ? ((INameable)blockEntity).func_145748_c_() : null;
            if (title == null) {
                title = new StringTextComponent(blockEntity.getClass().getSimpleName());
            }
            info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)title));
        }))))).then(Commands.func_197057_a((String)"entity").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSource>)context, (info, tag) -> {
            Entity entity = EntityArgument.func_197088_a((CommandContext)context, (String)"entity");
            if (entity instanceof PlayerEntity) {
                return;
            }
            info.func_74778_a("type", "entity");
            info.func_74768_a("id", entity.func_145782_y());
            entity.func_70039_c(tag);
            ListNBT list = new ListNBT();
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Class"), (ITextComponent)new StringTextComponent(entity.getClass().getName()));
            ResourceLocation key = Registries.getId((Object)entity.func_200600_R(), (RegistryKey)Registry.field_239713_n_);
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("ID"), (ITextComponent)new StringTextComponent(key == null ? "null" : key.toString()));
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Mod"), (ITextComponent)new StringTextComponent(key == null ? "null" : Platform.getOptionalMod((String)key.func_110624_b()).map(Mod::getName).orElse("Unknown")));
            info.func_218657_a("text", (INBT)list);
            info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)entity.func_145748_c_()));
        }))))).then(Commands.func_197057_a((String)"player").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSource>)context, (info, tag) -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)context, (String)"player");
            info.func_74778_a("type", "player");
            info.func_186854_a("id", player.func_110124_au());
            player.func_189511_e(tag);
            tag.func_82580_o("id");
            ListNBT list = new ListNBT();
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Name"), player.func_200200_C_());
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("Display Name"), player.func_145748_c_());
            FTBLibraryCommands.addInfo(list, (ITextComponent)new StringTextComponent("UUID"), (ITextComponent)new StringTextComponent(player.func_110124_au().toString()));
            info.func_218657_a("text", (INBT)list);
            info.func_74778_a("title", ITextComponent.Serializer.func_150696_a((ITextComponent)player.func_145748_c_()));
        }))))).then(Commands.func_197057_a((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<CommandSource>)context, (info, tag) -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            info.func_74778_a("type", "item");
            player.func_184586_b(Hand.MAIN_HAND).func_77955_b(tag);
        }))));
        if (Platform.isDevelopmentEnvironment()) {
            command.then(Commands.func_197057_a((String)"test_screen").executes(context -> {
                FTBLibrary.PROXY.testScreen();
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    private static void addInfo(ListNBT list, ITextComponent key, ITextComponent value) {
        list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)key.func_230532_e_().func_240699_a_(TextFormatting.BLUE).func_240702_b_(": ").func_230529_a_((ITextComponent)value.func_230532_e_().func_240699_a_(TextFormatting.GOLD)))));
    }

    private static int editNBT(CommandContext<CommandSource> context, NBTEditCallback data) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        CompoundNBT info = new CompoundNBT();
        CompoundNBT tag = new CompoundNBT();
        data.accept(info, tag);
        if (!info.isEmpty()) {
            EDITING_NBT.put(player.func_110124_au(), info);
            new EditNBTPacket(info, tag).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static interface NBTEditCallback {
        public void accept(CompoundNBT var1, CompoundNBT var2) throws CommandSyntaxException;
    }
}

